
function [AllObjects TotalLength EndPoint MaxY MinY]=CurevedWaveguide(Curved, RightWav,LeftSpotSizeConverter, RightSpotSizeConverter)
% position left [0,0]    note x is shifted left on plasmon position
% position right  [EndPoint(1) EndPoint(2)]  note x is shifted left on plasmon position
% TotalLength  is optical length of all waveguide

 %disp ('making curved waveguide')
    
 global MainWidth InLineWidth InLineGapWidth ConverterWidth ConverterLength ConnectorLength
    % upper inline x1 x2 center x3 x4  lower inline
    % x(point, line)
    
    TotalLength=0;    % total length of waveguide
    XLength=0;        % length along x-direction
   
    U=[1 1 1 1 1 1];
    CenterNow=[0;0]; nAlong=[1;0]; MinY=CenterNow(2);MaxY=CenterNow(2);
    % left line
    
    %main
    TillInLine=MainWidth/2-InLineWidth;
    TillMain=MainWidth/2-InLineWidth-InLineGapWidth;
    
    if LeftSpotSizeConverter
    % spot size converter

    TillInLineConv=ConverterWidth/2-InLineWidth;
    TillMainConv=ConverterWidth/2-InLineWidth-InLineGapWidth;
   
    x=[0 0 0 0 0 0];  y=[-ConverterWidth/2 -TillInLineConv -TillMainConv TillMainConv TillInLineConv  ConverterWidth/2];
    x=[x; U*ConverterLength]; y=[y; y];
    
    TotalLength=TotalLength+ConverterLength;
    
    
    CenterNow(1)=ConverterLength+ConnectorLength;
    x=[x; U*CenterNow(1)]; y=[y; -MainWidth/2 -TillInLine -TillMain TillMain TillInLine  MainWidth/2];
    
    else 
    
    x=[0 0 0 0 0 0];  y=[-MainWidth/2 -TillInLine -TillMain TillMain TillInLine  MainWidth/2];
    
    end
    dR=[MainWidth/2 TillInLine TillMain -TillMain -TillInLine  -MainWidth/2];
    
    
    for jj1=1:length(Curved(1,:))
 
          LineLen=Curved(1,jj1);
          TotalLength=TotalLength+LineLen;
         x=[x;  x(length(x(:,1)),:)+nAlong(1)*LineLen*U]; y=[y;  y(length(y(:,1)),:)+nAlong(2)*LineLen*U];
         
         CenterNow=CenterNow+nAlong*LineLen;
         
          
         
         if CenterNow(2)>MaxY;MaxY=CenterNow(2);end
         if CenterNow(2)<MinY;MinY=CenterNow(2);end
         
         fi1=Curved(3,jj1);
       nPerpendicular=[nAlong(2); -nAlong(1)]*sign(fi1);
        Radius0=Curved(2,jj1);
        RotationCenter=CenterNow+nPerpendicular*Radius0;
        
        TotalLength=TotalLength+Radius0*pi/180*fi1;
        
        
    for fi=1:sign(fi1):fi1
        fiP=fi*pi/180;
        MR=[cos(fiP) sin(fiP); -sin(fiP) cos(fiP)];
        VectorP=MR*nPerpendicular;
        CenterNow=RotationCenter-VectorP*Radius0;
         if CenterNow(2)>MaxY;MaxY=CenterNow(2);end
         if CenterNow(2)<MinY;MinY=CenterNow(2);end
        LSideX=RotationCenter(1)-VectorP(1)*(Radius0-sign(fi1)*dR);
        LSideY=RotationCenter(2)-VectorP(2)*(Radius0-sign(fi1)*dR);
        
         x=[x;  LSideX]; y=[y;  LSideY];
         
    end
       nAlong=[-VectorP(2); VectorP(1)]*sign(fi1);
      
    end
    
    
    
    %%% last line   
    
              LineLen=RightWav;
         x=[x;  x(length(x(:,1)),:)+nAlong(1)*LineLen*U]; y=[y;  y(length(y(:,1)),:)+nAlong(2)*LineLen*U];
         
         CenterNow=CenterNow+nAlong*LineLen;
    
         %%%%%
         if RightSpotSizeConverter
    % spot size converter  along x 
    
        TillInLineConv=ConverterWidth/2-InLineWidth;
    TillMainConv=ConverterWidth/2-InLineWidth-InLineGapWidth;
   TotalLength=TotalLength+ConverterLength;
      y0=y(length(y(:,1)),1)+MainWidth/2+[-ConverterWidth/2 -TillInLineConv -TillMainConv TillMainConv TillInLineConv  ConverterWidth/2];
    
    CenterNow(1)=CenterNow(1)+ConnectorLength;
    x=[x; CenterNow(1)*U]; y=[y; y0];
    CenterNow(1)=CenterNow(1)+ConverterLength;
    x=[x; CenterNow(1)*U];y=[y; y0];

    
         end
     
    EndPoint=CenterNow;
         %disp(['total length ' num2str(TotalLength/1000)   ' um end point' num2str(CenterNow(1)/1000) ' um']);
%         disp(['min max y ' num2str(minY) ' um ' num2str(maxY) ' um'])
         
   
     
    % x(point, line)
    x1=[x(:,3);flipud(x(:,4))];y1=[y(:,3);flipud(y(:,4))];
    AllObjects(1).MyObj=[x1 y1];
    AllObjects(1).MyRank=1;
        % x(point, line)
    x2=[x(:,2);flipud(x(:,1))];y2=[y(:,2);flipud(y(:,1))];
   AllObjects(2).MyObj=[x2 y2];
   AllObjects(2).MyRank=2;
    
   x3=[x(:,6);flipud(x(:,5))];y3=[y(:,6);flipud(y(:,5))];
   AllObjects(3).MyObj=[x3 y3];
   AllObjects(3).MyRank=2;